%% Code to design precoders for AoD estimation
% This code use (Sec. number)  to design the precoders.

%%%% Input parameters
% N_t : number of antennas at UE
% d_t : inter-element spacing at the UE
% M : number of grid points for AoD estimation
% K : number of precoders used in each stage 
% s : stage index

%%%%% Output
% W : set of precoders for sage s : N_t \times K^s


function W = get_code_TX(N_t, d_t, M, K, s)

    u_grid = linspace(-1,1,M);
    A = gen_a_v2(N_t,d_t,u_grid);  % dictionary
    ncodes = K^s;
    G = zeros(M,ncodes);
    G(:,1) = [ones(M/ncodes,1) ;  zeros((M - (M/ncodes)),1)];

    for i=2:ncodes
        G(:,i) = circshift(G(:,1),(i-1)*(M/ncodes));
    end

    Cs = inv(A*A')*A*G;
    W = zeros(N_t,ncodes); % Beamformers at stage s

    for i=1:ncodes
        W(:,i) = Cs(:,i)./norm(Cs(:,i));
    end

end